<?php
/*
CHMOD permission MODIFICATION FORM FOR FILES AND FOLDERS
Save this file in your web hosting directory, open it 
with your browser and follow the instructions.
An error report is provided. Delete the file after use.
*/

/* variable initialization */
$dosPerm = "0";
$ficPerm = "0";
$retval = "0"; /* CHMOD error count */

/* Path to the file to be processed */
    $chem = preg_replace('~[^_A-Za-z0-9-\.%\/]~i','', $_POST["chemin"]);    /* absolute file path (with cleanup against hacking) */
    $chem = preg_replace('/\.\.\//','', $chem);    /* you forbid the command ../ */
    define('ABSPATH', dirname(__FILE__));
    $chem = ABSPATH.$chem;    /* absolute file path of your account such as /home/loginftp/www/ or /home/loginftp/public_html/ etc. */

/* Folder permission */
    $d1 = filter_var($_POST["dir1"], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => '/^[57]$/')));
    $d2 = filter_var($_POST["dir2"], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => '/^[057]$/')));
    $d3 = filter_var($_POST["dir3"], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => '/^[057]$/')));
    $dosPerm = "0".$d1.$d2.$d3;
    $dosPerm = intval($dosPerm,8);
/* File permission */
    $f1 = filter_var($_POST["fic1"], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => '/^[46]$/i')));
    $f2 = filter_var($_POST["fic2"], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => '/^[046]$/i')));
    $f3 = filter_var($_POST["fic3"], FILTER_VALIDATE_REGEXP, array('options' => array('regexp' => '/^[046]$/i')));
    $ficPerm = "0".$f1.$f2.$f3;
    $ficPerm = intval($ficPerm, 8);

/* Html form to change permission */
    print "<html><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />";
    print "<body><h3>Changing CHMOD access permission to folders and files <br />in your hosting.</h3>";
    print "<table><tr><td>";
    print "<form method=\"post\">";
    print "<tr><td>Folder permission: </td>";
    print "<td><select name=\"dir1\"><option value=\"5\">5</option><option value=\"7\" selected>7</option></select><select name=\"dir2\"><option value=\"0\">0</option><option value=\"5\" selected>5</option><option value=\"7\">7</option></select><select name=\"dir3\"><option value=\"0\">0</option><option value=\"5\" selected>5</option><option value=\"7\">7</option></select></td></tr>";
    print "<tr><td>File permission: </td>";
    print "<td><select name=\"fic1\"><option value=\"4\">4</option><option value=\"6\" selected>6</option></select><select name=\"fic2\"><option value=\"0\">0</option><option value=\"4\" selected>4</option><option value=\"6\">6</option></select><select name=\"fic3\"><option value=\"0\">0</option><option value=\"4\" selected>4</option><option value=\"6\">6</option></select></td></tr>";
    print "<tr><td>Directory to control: </td>";
    print "<td>".ABSPATH." <input type=\"text\" name=\"chemin\" maxlength=\"80\" size=\"30\" value=\"/\" ></td></tr>";
    print "<tr><td> </td><td><strong style=\"color:red\">CAUTION: MODIFICATIONS INCLUDE CHILDREN'S FOLDERS AND THEIR FILES.</strong></td></tr>";
    print "<tr><td> </td><td><input type=\"submit\" value=\" Change CHMODs of Folders and Files \">";
    print "</form>";
    print "</td></tr></table>";

if ( ($dosPerm||$ficPerm) > 0 ){

    function rChmod($chem,$dosPerm,$ficPerm) {
        echo "<p><b>Log:</b></p>\r\n";

        $d = new RecursiveDirectoryIterator($chem, FilesystemIterator::SKIP_DOTS);
        foreach (new RecursiveIteratorIterator($d, 1) as $path) {
            $chmodret = false;
            $chmodresultat = "";
            if ( $path->isDir() ) {
            $chmodret = chmod( $path, $dosPerm ); }
            else {
            if ( is_file( $path )  ) {
            $chmodret = chmod( $path, $ficPerm ); }
            }
            if ($chmodret) {$chmodresultat = "OK"; }
            else {
                $chmodresultat = "ERROR";
                ++$retval;
                }
            echo $chmodresultat . " " . $path . "<br />\r\n";
        }
    return $retval;
    }
    $nbfailed = rChmod($chem,$dosPerm,$ficPerm);
    echo "<p><b>";
    if ($nbfailed > 0) {
        echo $nbfailed . " error(s) CHMOD. See the log above.";
        }
    else echo "No apparent error. Check for yourself.</b> Delete the file after use.</p>\r\n";
}
    print "</body></html>";
?>