<?php
// TEST PHP MAIL FUNCTION
// CREATE A FILE email.php

declare(strict_types=1); // Enable strict types

// *** Configure
$to = "adresse@machin.truc";  
$from  = "postmaster@bidule.truc";  

// *** Leave as is
$day = date("d-m-Y");
$time = date("H:i");

$subject = "Mail test - $day $time";

$htmlContent =<<<HTML
<html>
<head>
    <title>Subject</title>
</head>
<body>
    Simple HTML mail using PHP mail() function.<br> <b>$subject</b> <br>
</body>
</html>
HTML;

$headers = [
    "MIME-Version: 1.0",
    "Content-Transfer-Encoding: 8bit",
    "Content-type: text/html; charset=utf-8",
    "From: $from",
    // "Disposition-Notification-To: $from", // receipt notification
];

try {
    $mail_send_verification = mail($to, $subject, $htmlContent, implode("\n", $headers));
    if ($mail_send_verification === false) {
        throw new RuntimeException("Mail sending error");
    }
    echo " *** Mail sending verification=$mail_send_verification - Mail sent successfully to $to from $from with subject: $subject\n";
} catch (Throwable $e) {
    echo " ### Mail sending verification=$mail_send_verification - Mail sending error: " . $e->getMessage() . "\n";
}