<?php
// TEST FONCTION MAIL() PHP
// CREEZ UNE FICHIER email.php

declare(strict_types=1); // Enable strict types

// *** A configurer
$to = "adresse@machin.truc";  
$from  = "postmaster@bidule.truc";  

// *** Laisser tel quel
$jour = date("d-m-Y");
$heure = date("H:i");

$sujet = "Essai Mail - $jour $heure";

$htmlContenu =<<<HTML
<html>
<head>
    <title>Sujet</title>
</head>
<body>
    Mail au format HTML simple avec la fonction PHP mail().<br> <b>$sujet</b> <br>
</body>
</html>
HTML;

$headers = [
    "MIME-Version: 1.0",
    "Content-Transfer-Encoding: 8bit",
    "Content-type: text/html; charset=utf-8",
    "From: $from",
];

try {
    $verif_envoi_mail = mail($to, $sujet, $htmlContenu, implode("\n", $headers));
    if ($verif_envoi_mail === false) {
        throw new RuntimeException("Erreur envoi mail");
    }
    echo " *** Verification Envoi du Mail=$verif_envoi_mail - Mail envoyé avec succès vers $to depuis $from avec comme sujet: $sujet\n";
} catch (Throwable $e) {
    echo " ### Verification Envoi du Mail=$verif_envoi_mail - Erreur envoi mail: " . $e->getMessage() . "\n";
}