<?php
/*
Lists the last files created AND modified.
Very useful in case of hacking to know which files are added and which have been modified. Useful to understand the behavior of a script or CMS and see which files have been manipulated.

Save this script in your hosting, open it with your web browser, give the number of days representing the period to be checked, then the name of the folder to be scanned.
This script will only list folders from the path /home/yourloginftp/www/ of your hosting.

Delete the file after use.

Credits: 4/5 of the code is the work of Linda MacPhee-Cobb (http://timestocome.com)
*/
    $go_back = 0;                       /* display result or not */
    $i = 0;                                /* loop counter */
    $dir_count = 0;                        /* loop initialisation */
    $date = time();                        /* current date and time */
    $one_day = 86400;                    /* number of seconds for a day */
    $days = preg_replace('~[^0-9]~i','', $_POST["jours"]);    /* number of days to check */
    $path = preg_replace('~[^_A-Za-z0-9-\.%\/]~i','', $_POST["chemin"]);    /* absolute file path (with cleanup against hacking) */
    $path = preg_replace("/\.\.\//",'', $path);    /* you forbid the command ../ */
    define('ABSPATH', dirname(__FILE__));
    $path = ABSPATH.$path;    /* absolute file path of your account such as /home/loginftp/www/ or /home/loginftp/public_html/ etc. */
    $directories_to_read[$dir_count] = $path;
    
    /* Form to go back in time */
    print "<html><body><h3>Checking the last modified files <br /> in your hosting.</h3>";
    print "<table><tr><td>";
    print "<form method=\"post\">";
    print "<tr><td>Number of days to check 1-99: </td>";
    print "<td>&nbsp;&nbsp;<input type=\"text\" name=\"jours\" maxlength=\"2\" size=\"2\"></td></tr>";
    print "<tr><td>Name of the directory to check: </td>";
    print "<td>".ABSPATH." <input type=\"text\" name=\"chemin\" maxlength=\"80\" size=\"30\" value=\"/\" > (put a / at the end)</td></tr>";
    print "<tr><td> </td><td><input type=\"submit\" value=\" Check Files \">";
    print "</form>";
    print "</td></tr></table>";
    /* Result display */
    $go_back = $one_day * $days;
    print "<br /> Back to the <strong>" . ($go_back/$one_day) ."</strong> last days. <br /><br />";

    if ( $go_back > 0 ){
        print "<table><tr><th>File Name</th><th>Modification Date</th></tr>";
        $diff = $date - $go_back;
        
        while ( $i <= $dir_count ){
            $current_directory = $directories_to_read[$i];
        
            /* get file information */
            $read_path = opendir( $directories_to_read[$i] );
            while ( $file_name = readdir( $read_path)){
                if (( $file_name != '.' )&&( $file_name != '..' )){
                    if ( is_dir( $current_directory . "/"  . $file_name ) ){
                        /* need to get all the files in a directory */
                        $d_file_name = "$current_directory" . "$file_name";
                        $dir_count++;
                        $directories_to_read[$dir_count] = $d_file_name . "/";
                    }else{
                        $file_name = "$current_directory" . "$file_name";                                
                        /* If modified times more recent than x days, display, otherwise, pass */
                        if ( (@filemtime( $file_name)) > $diff  ){
                            print "<tr><td> $file_name </td>";
                            $date_changed = filemtime( $file_name );
                            $pretty_date = date("d/m/Y H:i:s", $date_changed);
                            print  "<td> ::: $pretty_date</td></tr>" ;
                        }
                    }
                }
            }
            @closedir ( $read_path );
            $i++;    
        }
            print "</table>";    
            print "<br />Delete the file after use.</body></html>";    
    } /* if go_back > 0 ) */
?>