<?php
/* Created by "Abogil", create a debug.php file */

// Enable PHP error logging
error_reporting(E_ALL);

// ****** Configuration Start ******
$DBhost = "server"; // SQL server address
$DBName = "name"; // SQL database name
$DBowner = "username"; // SQL username
$DBpw = "password"; // SQL password
// ****** Configuration End ******

try {
    // Connect to the database
    $fh_db = mysqli_connect($DBhost, $DBowner, $DBpw, $DBName);
    if (!$fh_db) {
        throw new Exception(
            "Error connecting to the database: " . mysqli_connect_error(),
        );
    } else {
        echo "1- Connection to the database = <strong>OK</strong> <br />\n";
    }
} catch (Exception $e) {
    echo "1- Error connection to the database = <strong>" .
        $e->getMessage() .
        "</strong> <br /> <br />\n";
}

try {
    // Select the database
    $sel = mysqli_select_db($fh_db, $DBName);
    if (!$sel) {
        throw new Exception(
            "Error selecting the database: " . mysqli_error($fh_db),
        );
    } else {
        echo "2- Access to the database $DBName = <strong>OK</strong> <br />\n";
    }
} catch (Exception $e) {
    echo "2- Error access to the database $DBName = <strong>" .
        $e->getMessage() .
        "</strong> <br /> <br />\n";
}

// Create the table Tab_test_DB
$sql_query =
    "CREATE TABLE `Tab_test_DB` ( `Id` int(11) NOT NULL auto_increment, `NOM` varchar(32) NOT NULL default '', `PRENOM` varchar(32) NOT NULL default '', PRIMARY KEY (`Id`)) ENGINE=MyISAM DEFAULT CHARSET=utf8";
try {
    // Execute the query
    $result_query = mysqli_query($fh_db, $sql_query);
    if (!$result_query) {
        throw new Exception(
            "Error creating the table: " . mysqli_error($fh_db),
        );
    } else {
        echo "3- Creation of the table Tab_test_DB = <strong>OK</strong> <br />\n";
    }
} catch (Exception $e) {
    echo "3- Error creating the table $sql_query = <strong>$sql_query</strong> <br /> $result_query = <strong>" .
        $e->getMessage() .
        "</strong> <br />\n";
}

// Add a record
$sql_query = "INSERT INTO `Tab_test_DB` values ('','NONYME','Anne')";
try {
    // Execute the query
    $result_query = mysqli_query($fh_db, $sql_query);
    if (!$result_query) {
        throw new Exception("Error adding a record: " . mysqli_error($fh_db));
    } else {
        echo "4- Addition of a record = <strong>OK</strong> <br />\n";
    }
} catch (Exception $e) {
    echo "4- Error adding of a record $sql_query = <strong>$sql_query</strong> <br /> $result_query = <strong>" .
        $e->getMessage() .
        "</strong> <br />\n";
}

// Select from the table Tab_test_DB
$sql_query =
    "SELECT Id, NOM, PRENOM FROM `Tab_test_DB` WHERE NOM LIKE 'NONYME'";
try {
    // Execute the query
    $result_query = mysqli_query($fh_db, $sql_query);
    if (!$result_query) {
        throw new Exception("Error selecting data: " . mysqli_error($fh_db));
    } else {
        echo "5- The column <strong>NOM</strong> containing the value <strong>NONYME</strong> has been found. <br />\n";
    }
} catch (Exception $e) {
    echo "5- Error finding a value $sql_query = <strong>$sql_query</strong> <br /> $result_query = <strong>" .
        $e->getMessage() .
        "</strong> <br />\n";
}

$sql_query = "SELECT Id, NOM, PRENOM FROM `Tab_test_DB` ORDER BY NOM";
try {
    // Execute the query
    $result_query = mysqli_query($fh_db, $sql_query);
    if (!$result_query) {
        throw new Exception("Error selecting data: " . mysqli_error($fh_db));
    }
    $result_count_row_get = mysqli_num_rows($result_query);
} catch (Exception $e) {
    echo "5- Error selecting a colon $sql_query = <strong>$sql_query</strong> <br /> $result_query = <strong>" .
        $e->getMessage() .
        "</strong> <br />\n";
}
echo "5- Number of results found = <strong>$result_count_row_get</strong> <br />\n";
mysqli_free_result($result_query);

// Drop the table Tab_test_DB
$sql_query = "DROP TABLE IF EXISTS `Tab_test_DB`";
try {
    // Execute the query
    $result_query = mysqli_query($fh_db, $sql_query);
    if (!$result_query) {
        throw new Exception(
            "Error dropping the table: " . mysqli_error($fh_db),
        );
    } else {
        echo "6- Dropping the table Tab_test_DB = <strong>OK</strong> <br />\n";
    }
} catch (Exception $e) {
    echo "6- $sql_query = <strong>$sql_query</strong> <br /> $result_query = <strong>" .
        $e->getMessage() .
        "</strong> <br />\n";
}

// Close the database connection
mysqli_close($fh_db);
?>